#!/usr/bin/perl
# Author: Steven Shiau <steven _at_ nchc org tw>
# License: GPL
# Description: Send s message to other machine via socket.
# Ref:http://www.perlfect.com/articles/sockets.shtml

use IO::Socket;

$usage="Usage: $0 [-h|--host HOSTNAME] [-p|--port PORT_NO] [-m|--message MSG]";
die "$usage\n" if $#ARGV<0;
while ( $_ = shift ) {
  if (/-p|--port/) { 
    $port = shift;
  }elsif(/-h|--host/) {
    $host = shift;
  }elsif(/-m|--message/) {
    $message = shift;
  }else{
    print $usage;
  }
}
die "$usage\n" if ! $host;
die "$usage\n" if ! $port;
die "$usage\n" if ! $message;

my $socket = new IO::Socket::INET (
                                  PeerAddr => "$host",
                                  PeerPort => "$port",
                                  Proto => 'tcp',
                                 );
die "Could not create socket to $host:$port!\n" unless $socket;
print $socket "$message\n";
close($socket);
