#!/bin/bash
# Author: Steven Shiau <steven _at_ nchc org tw>
# License: GPL

. /opt/drbl/sbin/drbl-conf-functions

# functions
USAGE() {
    echo "To start, restart or stop DRBL service in DRBL Live environment."
    echo "Usage:"
    echo "$0 {start|stop|restart}"
    echo "start   Start DRBL services now"
    echo "stop    Stop DRBL services now"
    echo "restart Restart DRBL services now"
    echo "Example: To start all DRBL services in this DRBL Live server"
    echo "$0 start"
}

# set locale for clients
set_locale_for_clients() {
  # Some of the code is referred to pakcage casper /usr/share/initramfs-tools/scripts/casper-bottom/14locales
  # We use the locale from server as the default one in client.
  if [ -e /etc/default/locale ]; then
      grep_file=/etc/default/locale
  elif [ -e /etc/environment ]; then # Old locales policy
      grep_file=/etc/environment
  fi
  if [ -n "${grep_file}" ]; then
      # use server's configured locale
      locale=$(grep -s 'LANG=' ${grep_file} | sed s/'LANG='// | tr -d '"' )
  fi
  if [ -z "$locale" ]; then
      # Set a default one
      locale=en_US.UTF-8
  fi
  LANG="${locale}"

  # write the setting in clients.
  for ih in $drblroot/*; do
    echo "LANG=${LANG}" > $ih/${grep_file}
  done
  echo "Since some config files are modified in template client, recreating template tarball for DRBL SSI..."
  $DRBL_SCRIPT_PATH/sbin/gen_ssi_files
} # end of set_locale_for_clients

check_if_root

#
if [ $# -ne 1 ]; then
  USAGE
  exit 1
fi

switch=$1

case "$switch" in
   "start"|"restart")
     # run drblpush again so that the network interface can be updated. Maybe there is new ethx.
     # load $client_no_per_NIC
     . /opt/drbl/setup/files/ocs/live-hook/ocs-live.conf
     yes "" | drblpush -i -r 1 -z 1 -p $client_no_per_NIC
     # turn on tcpwrapper
     echo "Setting /etc/hosts.allow..."
     mv -f /etc/hosts.allow /etc/hosts.allow.orig
     client_IP_list="$($DRBL_SCRIPT_PATH/bin/get-client-ip-list)"
     client_IP_list="$(echo $client_IP_list)"   # convert to 1 line
     client_IP_list_ar=( $client_IP_list )  # put it in an array
     # We can not list too long in hosts.allow, so put 20 elements in a line.
     nloop="$(echo "scale=0; ${#client_IP_list_ar[@]}/20 + 1" | bc -l )"
     for i in {1..$nloop}; do
       echo "ALL: ${client_IP_list_ar[@]:0:19}" > /etc/hosts.allow
     done

     # add and start all services
     echo "Adding DRBL-related services..."
     $DRBL_SCRIPT_PATH/sbin/drbl-all-service add
     echo "Starting DRBL service.."
     $DRBL_SCRIPT_PATH/sbin/drbl-all-service restart

     # set locales for clients.
     set_locale_for_clients
     ;;
   "stop")
     # block all the clients.
     mv -f /etc/hosts.allow /etc/hosts.allow.orig2
     echo "Disabled by drbl-live.sh" > /etc/hosts.allow

     # stop and remove all services
     echo "Stop DRBL service.."
     $DRBL_SCRIPT_PATH/sbin/drbl-all-service stop
     echo "Removing DRBL-related services..."
     $DRBL_SCRIPT_PATH/sbin/drbl-all-service del
     ;;
esac
