#!/bin/bash
# Steven Shiau <steven _at_ nchc org tw>
# License: GPL
# Des: download the syslinux and extract the necessary program for DRBL.
# The reason we do not use syslinux rpm/deb is that it's not easy to make
# all distribution works, otherwise you have to use the statically link program.
# I am lazy... do not want to compile it everytime.
SYSLINUX_URL="http://www.kernel.org/pub/linux/utils/boot/syslinux"

usage() {
  echo "Usage: $0 VERSION [stable|testing]"
  echo "Ex: $0 stable"
}

branch="$1"
case "$branch" in
  "stable"|"Stable")
     #stable, released one
     #echo "Searching the syslinux stable branch..."
     branch_path="./"
     ;;
  *)
     #echo "Searching the syslinux testing branch..."
     branch_path="Testing"
     ;;
esac

ver="$(cat syslinux/VERSION)"
[ -z "$ver" ] && exit 1
tarball=syslinux-${ver}.tar.gz
# The result is like:
# latest= 123. http://www.kernel.org/pub/linux/utils/boot/syslinux//Testing/syslinux-3.20-pre9.tar.gz
latest="$(lynx -dump $SYSLINUX_URL/$branch_path/ | grep -i "\<tar.gz$" 2>/dev/null | tail -n 1 2>/dev/null | awk -F" " '{print $2}')"
[ -n "$latest" ] && latest_tarball="$(basename $latest)"
if [ -n "$latest_tarball" -a "$latest_tarball" != "$tarball" ]; then
  echo "New version $latest_tarball is available in $SYSLINUX_URL/$branch_path/$latest_tarball"
fi
