
#include <glib.h>
#include "libindicate/indicator.h"
#include "libindicate/server.h"
#include "libindicate/interests.h"
#include "test-max-indicators-list.h"

static gboolean passed = TRUE;
static GMainLoop * mainloop = NULL;
static int count = 0;


static void
max_changed (IndicateServer * server, gint max, gpointer userdata)
{
	g_debug("Oh, max changed: %d", max);

	if (max != max_indicator_list[count]) {
		passed = FALSE;
		g_debug("\tBut that's not right!  We wanted: %d", max_indicator_list[count]);
	}
	count++;

	if (count == MAX_INDICATOR_COUNT) {
		g_main_loop_quit(mainloop);
	}

	return;
}

static gboolean
done_timeout_cb (gpointer data)
{
	g_debug("All maxes not set");
	passed = FALSE;
	g_main_loop_quit(mainloop);
	return FALSE;
}

int
main (int argc, char * argv)
{
	g_type_init();

	IndicateIndicator * indicator = indicate_indicator_new();
	indicate_indicator_show(indicator);

	IndicateServer * server = indicate_server_ref_default();
	g_signal_connect(G_OBJECT(server), INDICATE_SERVER_SIGNAL_MAX_INDICATORS_CHANGED, G_CALLBACK(max_changed), NULL);

	g_timeout_add(MAX_INDICATOR_COUNT * 10 * 100, done_timeout_cb, indicator);

	mainloop = g_main_loop_new(NULL, FALSE);
	g_main_loop_run(mainloop);

	return !passed;
}
