
#include <glib.h>
#include "libindicate/listener.h"
#include "test-max-indicators-list.h"

gint repeat_list[MAX_INDICATOR_COUNT] = { 2, 3, 1, 4, 2, 3, 1, 20 };

static gboolean passed = TRUE;
static GMainLoop * mainloop = NULL;

static guint count = 0;
static guint repeat = 0;

static IndicateListener * l = NULL;
static IndicateListenerServer * s = NULL;

gboolean
set_max (gpointer userdata)
{
	g_debug("Setting max indicators to: %d", max_indicator_list[count]);
	indicate_listener_set_server_max_indicators(l, s, max_indicator_list[count]);
	if (repeat == repeat_list[count]) {
		count++;
		repeat = 0;
	} else {
		repeat++;
	}

	if (count >= MAX_INDICATOR_COUNT) {
		return FALSE;
	} else {
		return TRUE;
	}
}

static void
server_added (IndicateListener * listener, IndicateListenerServer * server, gchar * type, gpointer data)
{
	g_debug("Indicator Server Added:   %s %s", INDICATE_LISTENER_SERVER_DBUS_NAME(server), type);

	if (l != NULL || s != NULL) {
		g_warning("Adding a second server?  %s", INDICATE_LISTENER_SERVER_DBUS_NAME(server));
		return;
	}

	l = listener;
	s = server;

	g_timeout_add(100, set_max, NULL);

	return;
}

static gboolean
failed_cb (gpointer data)
{
	g_debug("Done indicatating max indicators");
	g_main_loop_quit(mainloop);
	return FALSE;
}

int
main (int argc, char * argv)
{
	g_type_init();

	IndicateListener * listener = indicate_listener_ref_default();

	g_signal_connect(listener, INDICATE_LISTENER_SIGNAL_SERVER_ADDED, G_CALLBACK(server_added), NULL);

	guint i, repeat_sum = 0;
	for (i = 0; i < MAX_INDICATOR_COUNT; i++) {
		repeat_sum += repeat_list[i];
	}

	if (repeat_sum / MAX_INDICATOR_COUNT > 9) {
		g_warning("Risk of client timeout.");
	}

	g_timeout_add((MAX_INDICATOR_COUNT + 4 + repeat_sum) * 100, failed_cb, NULL);

	mainloop = g_main_loop_new(NULL, FALSE);
	g_main_loop_run(mainloop);

	return !passed;
}
